<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Service extends Model 
{

    protected $table = 'services';
    public $timestamps = true;
    protected $fillable = array('id', 'servable_type', 'servable_id', 'name_ar', 'name_en', 'description_ar', 'description_en', 'price');

    public function servable()
    {
        return $this->morphTo();
    }

    public function files()
    {
        return $this->morphMany('App\Models\File', 'filable');
    }

}